<?php    
/*
 * PHP QR Code encoder
 *
 * Exemplatory usage
 *
 * PHP QR Code is distributed under LGPL 3
 * Copyright (C) 2010 Dominik Dzienia <deltalab at poczta dot fm>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

echo "<h1>Gerador de QRcode - SérgioCJr</h1><hr/>";

// Set it to writable location, a place for temp generated PNG files
$PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;

// HTML PNG location prefix
$PNG_WEB_DIR = 'temp/';

include "qrlib.php";    

// Of course we need rights to create temp dir
if (!file_exists($PNG_TEMP_DIR))
    mkdir($PNG_TEMP_DIR);

$filename = $PNG_TEMP_DIR.'test.png';

// Processing form input
// Remember to sanitize user input in real-life solution !!!
$errorCorrectionLevel = 'H';
if (isset($_REQUEST['level']) && in_array($_REQUEST['level'], array('L','M','Q','H')))
    $errorCorrectionLevel = $_REQUEST['level'];    

$matrixPointSize = 4;
if (isset($_REQUEST['size']))
    $matrixPointSize = min(max((int)$_REQUEST['size'], 1), 10);

if (isset($_REQUEST['data'])) { 
    // It's very important!
    if (trim($_REQUEST['data']) == '')
        die('data cannot be empty! <a href="?">back</a>');
        
    // Sanitize the filename
    $data = preg_replace('/[^a-zA-Z0-9_-]/', '', $_REQUEST['data']);
    
    // User data
    $filename = $PNG_TEMP_DIR.'test'.md5($_REQUEST['data'].'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
    QRcode::png($_REQUEST['data'], $filename, $errorCorrectionLevel, $matrixPointSize, 2);    
    
    // Add logo
    $QR = imagecreatefrompng($filename);
    $logo = 'ico.png';
    
    if (file_exists($logo)) {
        $logo = imagecreatefrompng($logo);
        
        $QR_width = imagesx($QR);
        $QR_height = imagesy($QR);
        
        $logo_width = imagesx($logo);
        $logo_height = imagesy($logo);
        
        // Scale logo to fit in the QR Code
        $logo_qr_width = $QR_width / 5; // Adjust as needed
        $scale = $logo_width / $logo_qr_width;
        $logo_qr_height = $logo_height / $scale;
        
        // Calculate logo placement
        $logo_x = ($QR_width - $logo_qr_width) / 2;
        $logo_y = ($QR_height - $logo_qr_height) / 2;
        
        // Create a blank image with white background
        $QR_with_logo = imagecreatetruecolor($QR_width, $QR_height);
        $white = imagecolorallocate($QR_with_logo, 255, 255, 255);
        imagefill($QR_with_logo, 0, 0, $white);
        
        // Copy the original QR code onto the blank image
        imagecopy($QR_with_logo, $QR, 0, 0, 0, 0, $QR_width, $QR_height);

        // Copy the logo onto the QR code
        imagecopyresampled($QR_with_logo, $logo, $logo_x, $logo_y, 0, 0, $logo_qr_width, $logo_qr_height, $logo_width, $logo_height);
        
        // Save the final QR Code image with logo
        imagepng($QR_with_logo, $filename);
        imagedestroy($logo);
        imagedestroy($QR);
        imagedestroy($QR_with_logo);
    }

    // Set the download filename
    $download_filename = $data . '.png';
} else {    
    // Default data
    // echo 'You can provide data in GET parameter: <a href="?data=like_that">like that</a><hr/>';    
    // QRcode::png('PHP QR Code :)', $filename, $errorCorrectionLevel, $matrixPointSize, 2);    
}    
    
echo '<div style="text-align: center;">';
// Display generated file
if (isset($download_filename)) {
    echo '<img src="'.$PNG_WEB_DIR.basename($filename).'" /><hr/>';  

    // Add download button
    echo '<a href="'.$PNG_WEB_DIR.basename($filename).'" download="'.$download_filename.'" style="text-decoration: none;">
            <button style="padding: 10px 20px; font-size: 16px; cursor: pointer;">Download QR Code</button>
          </a><hr/>';
}

// Config form
echo '<form action="index.php" method="post" style="display: inline-block; text-align: left;">
    Link:&nbsp;<input name="data" value="'.(isset($_REQUEST['data'])?htmlspecialchars($_REQUEST['data']):'').'" />&nbsp;
    Tamanho:&nbsp;<select name="size">';
    
for($i=1;$i<=10;$i++)
    echo '<option value="'.$i.'"'.(($matrixPointSize==$i)?' selected':'').'>'.$i.'</option>';
    
echo '</select>&nbsp;
    <input type="submit" value="Gerar" style="padding: 5px 10px; font-size: 16px; cursor: pointer;"></form><hr/>
</div>';
?>
